<?xml version="1.0"?>


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="log">
<HTML>
	<HEAD>
		<TITLE>SAP Business One Log File</TITLE>
		<STYLE TYPE="text/css">
			BODY { font-family: Verdana, sans-serif }
			H1 { font-size: 150% }
			TABLE { border-collapse: collapse; font-size: 80%; text-align: left }
			TD, TH { border: solid thin #DAA520; border-spacing: 0px; padding: 1px 5px }
			TH { background: #FFD700; font-weight: bold }
			TD.space { border: none; height: 15px }
			TD.info { background: #F0E68C; }
			TD.message { background: #FFFACD; }
		</STYLE>
	</HEAD>
	<BODY>
		<H1>SAP Business One Log File</H1>
		<TABLE>
			<TR>
				<TH>Time Stamp</TH>
				<TH>Time Delta</TH>
				<TH>Component</TH>
				<TH>Severity</TH>
				<TH>PID</TH>
				<TH>Process Name</TH>
			</TR>
			<xsl:for-each select="LogMessage">
				<xsl:apply-templates select="."/>
			</xsl:for-each>
		</TABLE>
	</BODY>
</HTML>
	</xsl:template>

	<xsl:template match="LogMessage">
		<TR>
			<TD COLSPAN="6" CLASS="space"></TD>
		</TR>
		<TR>
			<TD CLASS="info">
				<xsl:call-template name="pretty-print-time">
					<xsl:with-param name="string" select="@TimeStamp"/>
				</xsl:call-template>
			</TD>
			<TD CLASS="info">
				<xsl:call-template name="print-time-difference">
					<xsl:with-param name="string1" select="preceding-sibling::LogMessage[1]/@TimeStamp"/>
					<xsl:with-param name="string2" select="@TimeStamp"/>
				</xsl:call-template>
			</TD>
			<TD CLASS="info"><xsl:value-of select="@Component"/></TD>
			<TD CLASS="info"><xsl:value-of select="@Severity"/></TD>
			<TD CLASS="info"><xsl:value-of select="@PID"/></TD>
			<TD CLASS="info"><xsl:value-of select="@ProcessName"/></TD>
		</TR>
		<TR>
			<TD COLSPAN="6" CLASS="message"><xsl:value-of select="MessageText"/></TD>
		</TR>
		<TR>
			<TD COLSPAN="6" CLASS="query"><xsl:value-of select="Query"/></TD>
		</TR>
	</xsl:template>
	
	<xsl:template name="pretty-print-time">
		<xsl:param name="string"/>

		<xsl:variable name="day" select="substring-before($string, '/')"/>
		<xsl:variable name="after-day" select="substring-after($string, '/')"/>
		<xsl:variable name="month" select="substring-before($after-day, '/')"/>
		<xsl:variable name="after-month" select="substring-after($after-day, '/')"/>
		<xsl:variable name="year" select="substring-before($after-month, ' ')"/>
		<xsl:variable name="after-year" select="substring-after($after-month, ' ')"/>
		<xsl:variable name="hour" select="substring-before($after-year, ':')"/>
		<xsl:variable name="after-hour" select="substring-after($after-year, ':')"/>
		<xsl:variable name="minute" select="substring-before($after-hour, ':')"/>
		<xsl:variable name="after-minute" select="substring-after($after-hour, ':')"/>
		<xsl:variable name="second" select="substring-before($after-minute, ':')"/>
		<xsl:variable name="milisecond" select="round(substring-after($after-minute, ':') div 1000)"/>

		<xsl:variable name="month-name">
			<xsl:choose>
				<xsl:when test="$month = 1">
					<xsl:text>Jan</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 2">
					<xsl:text>Feb</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 3">
					<xsl:text>Mar</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 4">
					<xsl:text>Apr</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 5">
					<xsl:text>May</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 6">
					<xsl:text>Jun</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 7">
					<xsl:text>Jul</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 8">
					<xsl:text>Aug</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 9">
					<xsl:text>Sep</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 10">
					<xsl:text>Oct</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 11">
					<xsl:text>Nov</xsl:text>
				</xsl:when>
				<xsl:when test="$month = 12">
					<xsl:text>Dec</xsl:text>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="correct-milisecond">
			<xsl:choose>
				<xsl:when test="$milisecond &lt; 10">
					<xsl:text>00</xsl:text>
					<xsl:value-of select="floor($milisecond)"/>
				</xsl:when>
				<xsl:when test="$milisecond &lt; 100">
					<xsl:text>0</xsl:text>
					<xsl:value-of select="floor($milisecond)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="floor($milisecond)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:value-of select="$month-name"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="floor($day)"/>
		<xsl:text>, </xsl:text>
		<xsl:value-of select="normalize-space($year)"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="floor($hour)"/>
		<xsl:text>:</xsl:text>
		<xsl:value-of select="normalize-space($minute)"/>
		<xsl:text>:</xsl:text>
		<xsl:value-of select="normalize-space($second)"/>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="$correct-milisecond"/>
	</xsl:template>
	
	<xsl:template name="print-time-difference">
		<xsl:param name="string1"/>
		<xsl:param name="string2"/>

		<xsl:variable name="day1" select="substring-before($string1, '/')"/>
		<xsl:variable name="day2" select="substring-before($string2, '/')"/>
		<xsl:variable name="after-day1" select="substring-after($string1, '/')"/>
		<xsl:variable name="after-day2" select="substring-after($string2, '/')"/>

		<xsl:variable name="month1" select="substring-before($after-day1, '/')"/>
		<xsl:variable name="month2" select="substring-before($after-day2, '/')"/>
		<xsl:variable name="after-month1" select="substring-after($after-day1, '/')"/>
		<xsl:variable name="after-month2" select="substring-after($after-day2, '/')"/>

		<xsl:variable name="year1" select="substring-before($after-month1, ' ')"/>
		<xsl:variable name="year2" select="substring-before($after-month2, ' ')"/>
		<xsl:variable name="after-year1" select="substring-after($after-month1, ' ')"/>
		<xsl:variable name="after-year2" select="substring-after($after-month2, ' ')"/>

		<xsl:variable name="hour1" select="substring-before($after-year1, ':')"/>
		<xsl:variable name="hour2" select="substring-before($after-year2, ':')"/>
		<xsl:variable name="after-hour1" select="substring-after($after-year1, ':')"/>
		<xsl:variable name="after-hour2" select="substring-after($after-year2, ':')"/>

		<xsl:variable name="minute1" select="substring-before($after-hour1, ':')"/>
		<xsl:variable name="minute2" select="substring-before($after-hour2, ':')"/>
		<xsl:variable name="after-minute1" select="substring-after($after-hour1, ':')"/>
		<xsl:variable name="after-minute2" select="substring-after($after-hour2, ':')"/>

		<xsl:variable name="second1" select="substring-before($after-minute1, ':')"/>
		<xsl:variable name="second2" select="substring-before($after-minute2, ':')"/>
		<xsl:variable name="milisecond1" select="round(substring-after($after-minute1, ':') div 1000)"/>
		<xsl:variable name="milisecond2" select="round(substring-after($after-minute2, ':') div 1000)"/>

		<xsl:variable name="ms-since-2k-1">
			<xsl:call-template name="date-to-int">
				<xsl:with-param name="year" select="$year1"/>
				<xsl:with-param name="month" select="$month1"/>
				<xsl:with-param name="day" select="$day1"/>
				<xsl:with-param name="hour" select="$hour1"/>
				<xsl:with-param name="minute" select="$minute1"/>
				<xsl:with-param name="second" select="$second1"/>
				<xsl:with-param name="milisecond" select="$milisecond1"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="ms-since-2k-2">
			<xsl:call-template name="date-to-int">
				<xsl:with-param name="year" select="$year2"/>
				<xsl:with-param name="month" select="$month2"/>
				<xsl:with-param name="day" select="$day2"/>
				<xsl:with-param name="hour" select="$hour2"/>
				<xsl:with-param name="minute" select="$minute2"/>
				<xsl:with-param name="second" select="$second2"/>
				<xsl:with-param name="milisecond" select="$milisecond2"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="ms-delta" select="$ms-since-2k-2 - $ms-since-2k-1"/>
		<xsl:variable name="seconds" select="floor($ms-delta div 1000)"/>
		<xsl:variable name="miliseconds" select="$ms-delta mod 1000"/>

		<xsl:if test="$ms-delta > 0">
			<xsl:value-of select="$seconds"/>
			<xsl:text>&#8201;s </xsl:text>
 			<xsl:value-of select="$miliseconds"/>
			<xsl:text>&#8201;ms</xsl:text>
		</xsl:if>
	</xsl:template>

	
	<xsl:template name="date-to-int">
		<xsl:param name="year"/>
		<xsl:param name="month"/>
		<xsl:param name="day"/>
		<xsl:param name="hour"/>
		<xsl:param name="minute"/>
		<xsl:param name="second"/>
		<xsl:param name="milisecond"/>

		<xsl:variable name="days-in-february">
			<xsl:choose>
				<xsl:when test="$year mod 400 = 0">
					<xsl:value-of select="29"/>
				</xsl:when>
				<xsl:when test="$year mod 100 = 0">
					<xsl:value-of select="28"/>
				</xsl:when>
				<xsl:when test="$year mod 4 = 0">
					<xsl:value-of select="29"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="28"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="days-before-month">
			<xsl:choose>
				<xsl:when test="$month = 1">
					<xsl:value-of select="0"/>
				</xsl:when>
				<xsl:when test="$month = 2">
					<xsl:value-of select="31"/>
				</xsl:when>
				<xsl:when test="$month = 3">
					<xsl:value-of select="31 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 4">
					<xsl:value-of select="62 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 5">
					<xsl:value-of select="92 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 6">
					<xsl:value-of select="123 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 7">
					<xsl:value-of select="153 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 8">
					<xsl:value-of select="184 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 9">
					<xsl:value-of select="215 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 10">
					<xsl:value-of select="245 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 11">
					<xsl:value-of select="276 + $days-in-february"/>
				</xsl:when>
				<xsl:when test="$month = 12">
					<xsl:value-of select="306 + $days-in-february"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="yd" select="$year - 2000"/>
		<xsl:variable name="days-before-year" select="$yd * 365 + floor(($yd + 3) div 4) - floor(($yd + 99) div 100) + floor(($yd + 399) div 400)"/>
		<xsl:variable name="days" select="$days-before-year + $days-before-month + $day - 1"/>

		<xsl:value-of select="((($days * 24 + $hour) * 60 + $minute) * 60 + $second) * 1000 + $milisecond"/>
 	</xsl:template>
</xsl:stylesheet>

